# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand, CommandError
import time


class Command(BaseCommand):
    option_list = BaseCommand.option_list + ()
    help = "Starts write data process."
    args = ''
    
    def handle(self, *args, **options):
        from server_update import update_user, update_device, clean_cache, update_finger, update_face, update_biodata
        from base.sync_api import server_update_data as ser_update
        from django.db import close_connection, reset_queries
        count = 0
        while True:
            try:
                ret = ser_update()
                update_user(ret['employee'])
                # update_finger(ret['finger'])
                # update_face(ret['face'])
                update_biodata(ret['biodatas'])
                update_device(ret['device'])
                reset_queries()
                time.sleep(10)
            except Exception, e:
                import traceback
                traceback.print_exc()
                count += 1
                if count > 3:
                    close_connection()
                    time.sleep(5 * 60)
                    raise e
                else:
                    time.sleep(60)
